/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.init.datagen;

import codechicken.lib.datagen.ConditionalIngredient;
import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.LanguageProvider;
import codechicken.lib.datagen.LootTableProvider;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.lib.datagen.recipe.ShapelessRecipeBuilder;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import morph.avaritia.block.MachineBlock;
import morph.avaritia.client.gui.NeutronCollectorScreen;
import morph.avaritia.client.gui.NeutroniumCompressorScreen;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.init.AvaritiaTags;
import morph.avaritia.init.datagen.CompressorRecipeBuilder;
import morph.avaritia.init.datagen.CosmicCustomLoaderBuilder;
import morph.avaritia.init.datagen.HaloCustomLoaderBuilder;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::registerDataGens);
    }

    private static void registerDataGens(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper files = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new BlockStates(gen, files));
            gen.m_123914_((DataProvider)new ItemModels(gen, files));
        }
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new BlockTagGen(gen, files));
            gen.m_123914_((DataProvider)new BlockLootTables(gen));
            gen.m_123914_((DataProvider)new Recipes(gen));
        }
        if (event.includeClient() || event.includeServer()) {
            gen.m_123914_((DataProvider)new UsLang(gen, LanguageProvider.getDist((GatherDataEvent)event)));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        protected BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "avaritia", exFileHelper);
        }

        private ResourceLocation extend(ResourceLocation rl, String suffix) {
            return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
        }

        private String name(Block block) {
            return block.getRegistryName().m_135815_();
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get());
            this.simpleBlock((Block)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get());
            this.simpleBlock((Block)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get());
            this.simpleBlock((Block)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_BLOCK.get());
            this.simpleBlock((Block)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_BLOCK.get());
            Block ect = (Block)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get();
            this.simpleBlock(ect, (ModelFile)this.models().cubeTop(this.name(ect), this.extend(this.blockTexture(ect), "_side"), this.extend(this.blockTexture(ect), "_top")));
            Block compressor = (Block)AvaritiaModContent.COMPRESSOR_BLOCK.get();
            ResourceLocation active = this.extend(this.blockTexture(compressor), "_active");
            ResourceLocation inactive = this.extend(this.blockTexture(compressor), "_inactive");
            ResourceLocation side = this.extend(this.blockTexture(compressor), "_side");
            ResourceLocation top = this.extend(this.blockTexture(compressor), "_top");
            ModelBuilder activeModel = ((BlockModelBuilder)this.models().cube(this.name(compressor), side, top, active, side, side, side)).texture("particle", active);
            ModelBuilder inactiveModel = ((BlockModelBuilder)this.models().cube(this.name(compressor) + "_inactive", side, top, inactive, side, side, side)).texture("particle", inactive);
            this.horizontalBlock(compressor, arg_0 -> BlockStates.lambda$registerStatesAndModels$0((ModelFile)activeModel, (ModelFile)inactiveModel, arg_0));
            Block collector = (Block)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get();
            active = this.extend(this.blockTexture(collector), "_active");
            inactive = this.extend(this.blockTexture(collector), "_inactive");
            side = this.extend(this.blockTexture(collector), "_side");
            top = this.extend(this.blockTexture(collector), "_top");
            activeModel = ((BlockModelBuilder)this.models().cube(this.name(collector), side, top, active, side, side, side)).texture("particle", active);
            inactiveModel = ((BlockModelBuilder)this.models().cube(this.name(collector) + "_inactive", side, top, inactive, side, side, side)).texture("particle", inactive);
            this.horizontalBlock(collector, arg_0 -> BlockStates.lambda$registerStatesAndModels$1((ModelFile)activeModel, (ModelFile)inactiveModel, arg_0));
        }

        private static /* synthetic */ ModelFile lambda$registerStatesAndModels$1(ModelFile activeModel, ModelFile inactiveModel, BlockState e) {
            return (Boolean)e.m_61143_((Property)MachineBlock.ACTIVE) != false ? activeModel : inactiveModel;
        }

        private static /* synthetic */ ModelFile lambda$registerStatesAndModels$0(ModelFile activeModel, ModelFile inactiveModel, BlockState e) {
            return (Boolean)e.m_61143_((Property)MachineBlock.ACTIVE) != false ? activeModel : inactiveModel;
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        protected ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "avaritia", existingFileHelper);
        }

        protected void registerModels() {
            this.simpleItemBlock((Block)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.COMPRESSOR_BLOCK.get());
            this.simpleItemBlock((Block)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get());
            this.generated((Supplier)AvaritiaModContent.DIAMOND_LATTICE);
            this.generated((Supplier)AvaritiaModContent.CRYSTAL_MATRIX_INGOT);
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.NEUTRON_PILE).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo_noise")).haloColor(0x33FFFFFF).haloSize(8);
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.NEUTRON_NUGGET).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo_noise")).haloColor(0x4DFFFFFF).haloSize(8);
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.NEUTRONIUM_INGOT).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo_noise")).haloColor(-1711276033).haloSize(8);
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.INFINITY_CATALYST).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo")).haloColor(-16777216).haloSize(10).pulse();
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.INFINITY_INGOT).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo")).haloColor(-16777216).haloSize(10).pulse();
            this.generated((Supplier)AvaritiaModContent.RECORD_FRAGMENT);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.IRON_SINGULARITY, 0x7F7F7F, 15132648);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.GOLD_SINGULARITY, 14393875, 15265571);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.LAPIS_SINGULARITY, 2247599, 5931746);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.REDSTONE_SINGULARITY, 0x900000, 0xDF0000);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.QUARTZ_SINGULARITY, 9733757, 0xFFFFFF);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.COPPER_SINGULARITY, 8999194, 14971392);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.TIN_SINGULARITY, 10201522, 10864606);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.LEAD_SINGULARITY, 4078926, 4472946);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.SILVER_SINGULARITY, 0xD5D5D5, 0xC0C0C0);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.NICKEL_SINGULARITY, 12895896, 14606727);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.DIAMOND_SINGULARITY, 9424329, 4566181);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.EMERALD_SINGULARITY, 9228656, 6078004);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.FLUXED_SINGULARITY, 16776341, 14033670);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.PLATINUM_SINGULARITY, 5931746, 49151);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.IRIDIUM_SINGULARITY, 15132410, 15132410);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.NETHERITE_SINGULARITY, 3221802, 6637376);
            this.singularity((Supplier<? extends Item>)AvaritiaModContent.AMETHYST_SINGULARITY, 5519754, 11767539);
            this.handheld((Supplier)AvaritiaModContent.INFINITY_AXE).folder("tools");
            ModelFile.UncheckedModelFile bowModel = new ModelFile.UncheckedModelFile("item/bow");
            ((CosmicCustomLoaderBuilder)this.getSimple((Supplier)AvaritiaModContent.INFINITY_BOW).parent((ModelFile)bowModel).texture(this.modLoc("item/tools/bow/idle")).customLoader(CosmicCustomLoaderBuilder::new)).maskTexture(this.modLoc("item/tools/bow/idle_mask")).end().override(arg_0 -> this.lambda$registerModels$1((ModelFile)bowModel, arg_0)).override(arg_0 -> this.lambda$registerModels$3((ModelFile)bowModel, arg_0)).override(arg_0 -> this.lambda$registerModels$5((ModelFile)bowModel, arg_0));
            this.handheld((Supplier)AvaritiaModContent.INFINITY_HOE).folder("tools");
            ItemModelBuilder pickaxeBuilder = this.getBuilder((Supplier)AvaritiaModContent.INFINITY_PICKAXE);
            ((ItemModelBuilder)pickaxeBuilder.parent((ModelFile)HANDHELD)).texture("layer0", new ResourceLocation("avaritia", "item/tools/infinity_pickaxe"));
            ItemModelBuilder hammerMode = (ItemModelBuilder)this.getBuilder(this.name((ItemLike)AvaritiaModContent.INFINITY_PICKAXE.get()) + "_hammer");
            ((ItemModelBuilder)hammerMode.parent((ModelFile)pickaxeBuilder)).texture("layer0", new ResourceLocation("avaritia", "item/tools/infinity_pickaxe_hammer"));
            pickaxeBuilder.override().model((ModelFile)hammerMode).predicate(new ResourceLocation("avaritia", "hammer"), 1.0f).end();
            ItemModelBuilder shovelBuilder = this.getBuilder((Supplier)AvaritiaModContent.INFINITY_SHOVEL);
            ((ItemModelBuilder)shovelBuilder.parent((ModelFile)HANDHELD)).texture("layer0", new ResourceLocation("avaritia", "item/tools/infinity_shovel"));
            ItemModelBuilder destroyerMode = (ItemModelBuilder)this.getBuilder(this.name((ItemLike)AvaritiaModContent.INFINITY_SHOVEL.get()) + "_destroyer");
            ((ItemModelBuilder)destroyerMode.parent((ModelFile)shovelBuilder)).texture("layer0", new ResourceLocation("avaritia", "item/tools/infinity_shovel_destroyer"));
            shovelBuilder.override().model((ModelFile)destroyerMode).predicate(new ResourceLocation("avaritia", "destroyer"), 1.0f).end();
            ((CosmicCustomLoaderBuilder)this.handheld((Supplier)AvaritiaModContent.INFINITY_SWORD).texture("layer0", this.modLoc("item/tools/infinity_sword_layer_0")).texture("layer1", this.modLoc("item/tools/infinity_sword_layer_1")).customLoader(CosmicCustomLoaderBuilder::new)).maskTexture(this.modLoc("item/tools/infinity_sword_mask"));
            this.handheld((Supplier)AvaritiaModContent.SKULLFIRE_SWORD).folder("tools");
            this.generated((Supplier)AvaritiaModContent.MATTER_CLUSTER);
            ((HaloCustomLoaderBuilder)this.generated((Supplier)AvaritiaModContent.ENDEST_PEARL_ITEM).customLoader(HaloCustomLoaderBuilder::new)).haloTexture("halo", new ResourceLocation("avaritia", "item/halo")).haloColor(-16777216).haloSize(4).pulse();
            this.generated((Supplier)AvaritiaModContent.ULTIMATE_STEW);
            this.generated((Supplier)AvaritiaModContent.COSMIC_MEATBALLS);
            this.generated((Supplier)AvaritiaModContent.INFINITY_HELMET).folder("armor");
            this.generated((Supplier)AvaritiaModContent.INFINITY_CHESTPLATE).folder("armor");
            this.generated((Supplier)AvaritiaModContent.INFINITY_LEGS).folder("armor");
            this.generated((Supplier)AvaritiaModContent.INFINITY_BOOTS).folder("armor");
        }

        public String m_6055_() {
            return "Avaritia Item Models";
        }

        private void singularity(Supplier<? extends Item> item, int layer0Color, int layer1Color) {
            ((HaloCustomLoaderBuilder)this.generated(item).texture("layer0", new ResourceLocation("avaritia", "item/singularity_layer_0")).texture("layer1", new ResourceLocation("avaritia", "item/singularity_layer_1")).customLoader(HaloCustomLoaderBuilder::new)).addLayerColor(layer0Color).addLayerColor(layer1Color).haloTexture("halo", new ResourceLocation("avaritia", "item/halo")).haloSize(4);
        }

        private /* synthetic */ void lambda$registerModels$5(ModelFile bowModel, ItemModelProvider.OverrideBuilder o) {
            o.predicate(this.modLoc("pulling"), 1.0f).predicate(this.modLoc("pull"), 0.9f).model(this.name((ItemLike)AvaritiaModContent.INFINITY_BOW.get()) + "_pull_2", m -> ((CosmicCustomLoaderBuilder)m.parent(bowModel).texture(this.modLoc("item/tools/bow/pull_2")).customLoader(CosmicCustomLoaderBuilder::new)).maskTexture(this.modLoc("item/tools/bow/pull_2_mask")).end());
        }

        private /* synthetic */ void lambda$registerModels$3(ModelFile bowModel, ItemModelProvider.OverrideBuilder o) {
            o.predicate(this.modLoc("pulling"), 1.0f).predicate(this.modLoc("pull"), 0.65f).model(this.name((ItemLike)AvaritiaModContent.INFINITY_BOW.get()) + "_pull_1", m -> ((CosmicCustomLoaderBuilder)m.parent(bowModel).texture(this.modLoc("item/tools/bow/pull_1")).customLoader(CosmicCustomLoaderBuilder::new)).maskTexture(this.modLoc("item/tools/bow/pull_1_mask")).end());
        }

        private /* synthetic */ void lambda$registerModels$1(ModelFile bowModel, ItemModelProvider.OverrideBuilder o) {
            o.predicate(this.modLoc("pulling"), 1.0f).model(this.name((ItemLike)AvaritiaModContent.INFINITY_BOW.get()) + "_pull_0", m -> ((CosmicCustomLoaderBuilder)m.parent(bowModel).texture(this.modLoc("item/tools/bow/pull_0")).customLoader(CosmicCustomLoaderBuilder::new)).maskTexture(this.modLoc("item/tools/bow/pull_0_mask")).end());
        }
    }

    private static class BlockTagGen
    extends BlockTagsProvider {
        protected BlockTagGen(DataGenerator p_126511_, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_126511_, "avaritia", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144284_).m_126582_((Object)((Block)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get())).m_126582_((Object)((Block)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get())).m_126582_((Object)((Block)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()));
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get())).m_126582_((Object)((Block)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get())).m_126582_((Object)((Block)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()));
            this.m_206424_(BlockTags.f_144280_).m_126582_((Object)((Block)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_BLOCK.get())).m_126582_((Object)((Block)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_BLOCK.get()));
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get()));
            this.m_206424_(BlockTags.f_144284_).m_126582_((Object)((Block)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get()));
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)AvaritiaModContent.COMPRESSOR_BLOCK.get()));
            this.m_206424_(BlockTags.f_144284_).m_126582_((Object)((Block)AvaritiaModContent.COMPRESSOR_BLOCK.get()));
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get()));
            this.m_206424_(BlockTags.f_144284_).m_126582_((Object)((Block)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get()));
            this.m_206424_(AvaritiaTags.Blocks.MINEABLE_WITH_INFINITY_AXE).m_206428_(BlockTags.f_13035_).m_206428_(BlockTags.f_13063_).m_206428_(BlockTags.f_198158_).m_206428_(BlockTags.f_144275_).m_206428_(BlockTags.f_13063_).m_206428_(BlockTags.f_144280_);
            this.m_206424_(AvaritiaTags.Blocks.MINEABLE_WITH_INFINITY_PICKAXE).m_206428_(BlockTags.f_144283_).m_206428_(BlockTags.f_144282_);
            this.m_206424_(AvaritiaTags.Blocks.MINEABLE_WITH_INFINITY_SHOVEL).m_206428_(BlockTags.f_144283_);
        }

        public String m_6055_() {
            return "Avaritia Block Tags.";
        }
    }

    private static class BlockLootTables
    extends LootTableProvider.BlockLootProvider {
        protected BlockLootTables(DataGenerator dataGenerator) {
            super(dataGenerator);
        }

        protected void registerTables() {
            this.register((Block)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.NEUTRONIUM_STORAGE_ITEM.get())});
            this.register((Block)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.INFINITY_STORAGE_ITEM.get())});
            this.register((Block)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_ITEM.get())});
            this.register((Block)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get())});
            this.register((Block)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get())});
            this.register((Block)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK.get(), new LootPool.Builder[]{this.singleItemCustomised((ItemLike)AvaritiaModContent.EXTREME_CRAFTING_TABLE_ITEM.get(), e -> e.m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Matrix", "BlockEntityTag.Matrix").m_80279_("Result", "BlockEntityTag.Result")))});
            this.register((Block)AvaritiaModContent.COMPRESSOR_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.COMPRESSOR_ITEM.get())});
            this.register((Block)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get(), new LootPool.Builder[]{this.singleItem((ItemLike)AvaritiaModContent.NEUTRON_COLLECTOR_ITEM.get())});
        }

        protected LootPool.Builder singleItemCustomised(ItemLike item, UnaryOperator<LootPoolSingletonContainer.Builder<?>> func) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)func.apply(LootItem.m_79579_((ItemLike)item)));
        }

        public String m_6055_() {
            return "Avaritia Block Tags";
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void registerRecipes() {
            this.shapedRecipe((ItemLike)AvaritiaModContent.DIAMOND_LATTICE.get()).key('D', Tags.Items.GEMS_DIAMOND).patternLine("D D").patternLine(" D ").patternLine("D D");
            this.shapedRecipe((ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('D', (ItemLike)AvaritiaModContent.DIAMOND_LATTICE.get()).key('S', Tags.Items.NETHER_STARS).patternLine("DSD").patternLine("DSD");
            this.shapelessRecipe((ItemLike)AvaritiaModContent.NEUTRON_PILE.get(), 9, new ResourceLocation("avaritia", "un_neutron_nugget")).addIngredient((ItemLike)AvaritiaModContent.NEUTRON_NUGGET.get());
            this.shapedRecipe((ItemLike)AvaritiaModContent.NEUTRON_NUGGET.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRON_PILE.get()).patternLine("NNN").patternLine("NNN").patternLine("NNN");
            this.shapelessRecipe((ItemLike)AvaritiaModContent.NEUTRON_NUGGET.get(), 9, new ResourceLocation("avaritia", "un_neutronium_ingot")).addIngredient((ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get());
            this.shapedRecipe((ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRON_NUGGET.get()).patternLine("NNN").patternLine("NNN").patternLine("NNN");
            this.shapedRecipe((ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()).key('C', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).patternLine("CCC").patternLine("CCC").patternLine("CCC");
            this.shapedRecipe((ItemLike)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("NNN").patternLine("NNN").patternLine("NNN");
            this.shapelessRecipe((ItemLike)AvaritiaModContent.INFINITY_INGOT.get(), 9, new ResourceLocation("avaritia", "un_infinity_block")).addIngredient((ItemLike)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get());
            this.extremeShapeless((ItemLike)AvaritiaModContent.INFINITY_CATALYST.get()).addIngredient((ItemLike)AvaritiaModContent.DIAMOND_LATTICE.get()).addIngredient((ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).addIngredient((ItemLike)AvaritiaModContent.NEUTRON_PILE.get()).addIngredient((ItemLike)AvaritiaModContent.NEUTRON_NUGGET.get()).addIngredient((ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).addIngredient((ItemLike)AvaritiaModContent.RECORD_FRAGMENT.get()).addIngredient((ItemLike)AvaritiaModContent.IRON_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.LAPIS_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.REDSTONE_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.QUARTZ_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.DIAMOND_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.EMERALD_SINGULARITY.get()).addIngredient((ItemLike)AvaritiaModContent.COPPER_SINGULARITY.get()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_TIN))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.TIN_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_LEAD))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.LEAD_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_SILVER))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.SILVER_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_NICKEL))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.NICKEL_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_ELECTRUM_FLUX))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.FLUXED_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_ENDERIUM))).withPass(Ingredient.m_204132_(AvaritiaTags.Items.STORAGE_BLOCK_ENDERIUM)).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_STEEL))).withPass(Ingredient.m_204132_(AvaritiaTags.Items.STORAGE_BLOCK_STEEL)).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_DARK_STEEL))).withPass(Ingredient.m_204132_(AvaritiaTags.Items.STORAGE_BLOCK_DARK_STEEL)).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_PLATINUM))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.PLATINUM_SINGULARITY.get()})).build()).addIngredient((Ingredient)ConditionalIngredient.builder().withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_IRIDIUM))).withPass(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AvaritiaModContent.IRIDIUM_SINGULARITY.get()})).build());
            this.shapelessRecipe((ItemLike)AvaritiaModContent.RECORD_FRAGMENT.get(), 8).addIngredient(ItemTags.f_13158_);
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('C', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.INFINITY_CATALYST.get()).patternLine("NNNNNNNNN").patternLine("NCXXCXXCN").patternLine("NXCCXCCXN").patternLine("NCXXCXXCN").patternLine("NNNNNNNNN").patternLine("         ").patternLine("         ").patternLine("         ").patternLine("         ");
            this.shapedRecipe((ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get()).key('C', (ItemLike)Blocks.f_50091_).patternLine("CCC").patternLine("CCC").patternLine("CCC");
            this.shapelessRecipe((ItemLike)Blocks.f_50091_, 9, new ResourceLocation("avaritia", "un_compressed_crafting_table")).addIngredient((ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get());
            this.shapedRecipe((ItemLike)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get()).key('C', (ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get()).patternLine("CCC").patternLine("CCC").patternLine("CCC");
            this.shapelessRecipe((ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get(), 9, new ResourceLocation("avaritia", "un_double_compressed_crafting_table")).addIngredient((ItemLike)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get());
            this.shapedRecipe((ItemLike)AvaritiaModContent.EXTREME_CRAFTING_TABLE_ITEM.get()).key('C', (ItemLike)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_ITEM.get()).key('I', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).patternLine("III").patternLine("ICI").patternLine("III");
            this.shapedRecipe((ItemLike)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).patternLine("III").patternLine("III").patternLine("III");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_AXE.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("   I     ").patternLine("  IIIII  ").patternLine("   IIII  ").patternLine("     IN  ").patternLine("      N  ").patternLine("      N  ").patternLine("      N  ").patternLine("      N  ").patternLine("      N  ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_BOW.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()).key('W', ItemTags.f_13167_).patternLine("   II    ").patternLine("  I W    ").patternLine(" I  W    ").patternLine("I   W    ").patternLine("X   W    ").patternLine("I   W    ").patternLine(" I  W    ").patternLine("  I W    ").patternLine("   II    ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_HOE.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("     N   ").patternLine(" IIIIII  ").patternLine("IIIIIII  ").patternLine("I    II  ").patternLine("     N   ").patternLine("     N   ").patternLine("     N   ").patternLine("     N   ").patternLine("     N   ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_PICKAXE.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('C', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine(" IIIIIII ").patternLine("IIIICIIII").patternLine("II  N  II").patternLine("    N    ").patternLine("    N    ").patternLine("    N    ").patternLine("    N    ").patternLine("    N    ").patternLine("    N    ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_SHOVEL.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.INFINITY_STORAGE_BLOCK.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("      III").patternLine("     IIXI").patternLine("      III").patternLine("     N I ").patternLine("    N    ").patternLine("   N     ").patternLine("  N      ").patternLine(" N       ").patternLine("N        ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_SWORD.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.INFINITY_CATALYST.get()).key('C', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("       II").patternLine("      III").patternLine("     III ").patternLine("    III  ").patternLine(" C III   ").patternLine("  CII    ").patternLine("  NC     ").patternLine(" N  C    ").patternLine("X        ");
            this.extremeShaped((ItemLike)AvaritiaModContent.SKULLFIRE_SWORD.get()).key('I', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('X', (ItemLike)Items.f_42593_).key('B', (ItemLike)Items.f_42500_).key('D', (ItemLike)Items.f_42686_).key('W', ItemTags.f_13182_).patternLine("       IX").patternLine("      IXI").patternLine("     IXI ").patternLine("    IXI  ").patternLine(" B IXI   ").patternLine("  BXI    ").patternLine("  WB     ").patternLine(" W  B    ").patternLine("D        ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_HELMET.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.INFINITY_CATALYST.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("  NNNNN  ").patternLine(" NIIIIIN ").patternLine(" N XIX N ").patternLine(" NIIIIIN ").patternLine(" NIIIIIN ").patternLine(" NI I IN ").patternLine("         ").patternLine("         ").patternLine("         ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_CHESTPLATE.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine(" NN   NN ").patternLine("NNN   NNN").patternLine("NNN   NNN").patternLine(" NIIIIIN ").patternLine(" NIIXIIN ").patternLine(" NIIIIIN ").patternLine(" NIIIIIN ").patternLine(" NIIIIIN ").patternLine("  NNNNN  ");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_LEGS.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('X', (ItemLike)AvaritiaModContent.INFINITY_CATALYST.get()).key('C', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("NNNNNNNNN").patternLine("NIIIXIIIN").patternLine("NINNXNNIN").patternLine("NIN   NIN").patternLine("NCN   NCN").patternLine("NIN   NIN").patternLine("NIN   NIN").patternLine("NIN   NIN").patternLine("NNN   NNN");
            this.extremeShaped((ItemLike)AvaritiaModContent.INFINITY_BOOTS.get()).key('I', (ItemLike)AvaritiaModContent.INFINITY_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine(" NNN NNN ").patternLine(" NIN NIN ").patternLine(" NIN NIN ").patternLine("NNIN NINN").patternLine("NIIN NIIN").patternLine("NNNN NNNN").patternLine("         ").patternLine("         ").patternLine("         ");
            this.extremeShaped((ItemLike)AvaritiaModContent.ENDEST_PEARL_ITEM.get()).key('E', Tags.Items.END_STONES).key('P', Tags.Items.ENDER_PEARLS).key('S', Tags.Items.NETHER_STARS).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).patternLine("   EEE   ").patternLine(" EEPPPEE ").patternLine(" EPPPPPE ").patternLine("EPPPNPPPE").patternLine("EPPNSNPPE").patternLine("EPPPNPPPE").patternLine(" EPPPPPE ").patternLine(" EEPPPEE ").patternLine("   EEE   ");
            this.extremeShapeless((ItemLike)AvaritiaModContent.ULTIMATE_STEW.get(), 4).addIngredient(Tags.Items.CROPS_WHEAT).addIngredient(Tags.Items.CROPS_WHEAT).addIngredient(Tags.Items.CROPS_CARROT).addIngredient(Tags.Items.CROPS_CARROT).addIngredient(Tags.Items.CROPS_POTATO).addIngredient(Tags.Items.CROPS_POTATO).addIngredient(Tags.Items.CROPS_BEETROOT).addIngredient(Tags.Items.CROPS_BEETROOT).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42410_).addIngredient((ItemLike)Items.f_42028_).addIngredient((ItemLike)Items.f_42028_).addIngredient((ItemLike)Blocks.f_50133_).addIngredient((ItemLike)Blocks.f_50133_).addIngredient((ItemLike)Blocks.f_50128_).addIngredient((ItemLike)Blocks.f_50128_).addIngredient((ItemLike)Blocks.f_50073_).addIngredient((ItemLike)Blocks.f_50073_).addIngredient((ItemLike)Blocks.f_50072_).addIngredient((ItemLike)Blocks.f_50072_).addIngredient((ItemLike)AvaritiaModContent.NEUTRON_PILE.get());
            this.extremeShapeless((ItemLike)AvaritiaModContent.COSMIC_MEATBALLS.get(), 2).addIngredient((ItemLike)Items.f_42526_).addIngredient((ItemLike)Items.f_42526_).addIngredient((ItemLike)Items.f_42485_).addIngredient((ItemLike)Items.f_42485_).addIngredient((ItemLike)Items.f_42697_).addIngredient((ItemLike)Items.f_42697_).addIngredient((ItemLike)Items.f_42527_).addIngredient((ItemLike)Items.f_42527_).addIngredient((ItemLike)Items.f_42581_).addIngredient((ItemLike)Items.f_42581_).addIngredient((ItemLike)Items.f_42579_).addIngredient((ItemLike)Items.f_42579_).addIngredient((ItemLike)Items.f_42658_).addIngredient((ItemLike)Items.f_42658_).addIngredient((ItemLike)AvaritiaModContent.NEUTRON_PILE.get());
            this.extremeShaped((ItemLike)AvaritiaModContent.COMPRESSOR_ITEM.get()).key('X', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('N', (ItemLike)AvaritiaModContent.NEUTRONIUM_INGOT.get()).key('I', Tags.Items.STORAGE_BLOCKS_IRON).key('H', (ItemLike)Items.f_42155_).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).key('O', (ItemLike)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK.get()).patternLine("IIIHHHIII").patternLine("X N   N X").patternLine("I N   N I").patternLine("X N   N X").patternLine("RNN O NNR").patternLine("X N   N X").patternLine("I N   N I").patternLine("X N   N X").patternLine("IIIXIXIII");
            this.extremeShaped((ItemLike)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK.get()).key('X', (ItemLike)AvaritiaModContent.CRYSTAL_MATRIX_INGOT.get()).key('I', Tags.Items.STORAGE_BLOCKS_IRON).key('Q', Tags.Items.STORAGE_BLOCKS_QUARTZ).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).patternLine("IIQQQQQII").patternLine("I QQQQQ I").patternLine("I  RRR  I").patternLine("X RRRRR X").patternLine("I RRXRR I").patternLine("X RRRRR X").patternLine("I  RRR  I").patternLine("I       I").patternLine("IIIXIXIII");
            this.compressorRecipe((ItemLike)AvaritiaModContent.IRON_SINGULARITY.get()).cost(400).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            this.compressorRecipe((ItemLike)AvaritiaModContent.GOLD_SINGULARITY.get()).cost(200).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            this.compressorRecipe((ItemLike)AvaritiaModContent.LAPIS_SINGULARITY.get()).cost(200).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            this.compressorRecipe((ItemLike)AvaritiaModContent.REDSTONE_SINGULARITY.get()).cost(200).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            this.compressorRecipe((ItemLike)AvaritiaModContent.QUARTZ_SINGULARITY.get()).cost(200).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ);
            this.compressorRecipe((ItemLike)AvaritiaModContent.COPPER_SINGULARITY.get()).cost(400).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.TIN_SINGULARITY.get()).cost(400).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_TIN)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_TIN);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.LEAD_SINGULARITY.get()).cost(300).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_LEAD)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_LEAD);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.SILVER_SINGULARITY.get()).cost(300).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_SILVER)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_SILVER);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.NICKEL_SINGULARITY.get()).cost(400).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_NICKEL)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_NICKEL);
            this.compressorRecipe((ItemLike)AvaritiaModContent.DIAMOND_SINGULARITY.get()).cost(300).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            this.compressorRecipe((ItemLike)AvaritiaModContent.EMERALD_SINGULARITY.get()).cost(200).addIngredient((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.FLUXED_SINGULARITY.get()).cost(100).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_ELECTRUM_FLUX)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_ELECTRUM_FLUX);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.PLATINUM_SINGULARITY.get()).cost(80).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_PLATINUM)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_PLATINUM);
            ((CompressorRecipeBuilder)this.compressorRecipe((ItemLike)AvaritiaModContent.IRIDIUM_SINGULARITY.get()).cost(80).withCondition(e -> e.not(e.tagEmpty(AvaritiaTags.Items.STORAGE_BLOCK_IRIDIUM)))).addIngredient(AvaritiaTags.Items.STORAGE_BLOCK_IRIDIUM);
        }

        public String m_6055_() {
            return "Avaritia Recipes";
        }

        protected ShapedRecipeBuilder extremeShaped(ItemLike result) {
            return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get()), (ItemLike)result, (int)1));
        }

        protected ShapedRecipeBuilder extremeShaped(ItemLike result, int count) {
            return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get()), (ItemStack)new ItemStack(result, count)));
        }

        protected ShapedRecipeBuilder extremeShaped(ItemLike result, int count, ResourceLocation id) {
            return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get()), (ItemStack)new ItemStack(result, count), (ResourceLocation)id));
        }

        protected ShapedRecipeBuilder extremeShaped(ItemStack result) {
            return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get()), (ItemStack)result, (ResourceLocation)result.m_41720_().getRegistryName()));
        }

        protected ShapedRecipeBuilder extremeShaped(ItemStack result, ResourceLocation id) {
            return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPED_RECIPE.get()), (ItemStack)result, (ResourceLocation)id));
        }

        protected ShapelessRecipeBuilder extremeShapeless(ItemLike result) {
            return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPELESS_RECIPE.get()), (ItemLike)result, (int)1));
        }

        protected ShapelessRecipeBuilder extremeShapeless(ItemLike result, int count) {
            return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPELESS_RECIPE.get()), (ItemStack)new ItemStack(result, count)));
        }

        protected ShapelessRecipeBuilder extremeShapeless(ItemLike result, int count, ResourceLocation id) {
            return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPELESS_RECIPE.get()), (ItemStack)new ItemStack(result, count), (ResourceLocation)id));
        }

        protected ShapelessRecipeBuilder extremeShapeless(ItemStack result) {
            return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPELESS_RECIPE.get()), (ItemStack)result, (ResourceLocation)result.m_41720_().getRegistryName()));
        }

        protected ShapelessRecipeBuilder extremeShapeless(ItemStack result, ResourceLocation id) {
            return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.custom((RecipeSerializer)((RecipeSerializer)AvaritiaModContent.EXTREME_SHAPELESS_RECIPE.get()), (ItemStack)result, (ResourceLocation)id));
        }

        protected CompressorRecipeBuilder compressorRecipe(ItemLike result) {
            return (CompressorRecipeBuilder)this.builder((RecipeBuilder)CompressorRecipeBuilder.builder(result, 1));
        }

        protected CompressorRecipeBuilder compressorRecipe(ItemLike result, int count) {
            return (CompressorRecipeBuilder)this.builder((RecipeBuilder)CompressorRecipeBuilder.builder(new ItemStack(result, count)));
        }

        protected CompressorRecipeBuilder compressorRecipe(ItemLike result, int count, ResourceLocation id) {
            return (CompressorRecipeBuilder)this.builder((RecipeBuilder)CompressorRecipeBuilder.builder(new ItemStack(result, count), id));
        }

        protected CompressorRecipeBuilder compressorRecipe(ItemStack result) {
            return (CompressorRecipeBuilder)this.builder((RecipeBuilder)CompressorRecipeBuilder.builder(result, result.m_41720_().getRegistryName()));
        }

        protected CompressorRecipeBuilder compressorRecipe(ItemStack result, ResourceLocation id) {
            return (CompressorRecipeBuilder)this.builder((RecipeBuilder)CompressorRecipeBuilder.builder(result, id));
        }
    }

    private static class UsLang
    extends LanguageProvider {
        protected UsLang(DataGenerator gen, LanguageProvider.Side distFilter) {
            super(gen, "avaritia", "en_us", distFilter);
        }

        protected void addTranslations() {
            this.add("itemGroup.avaritia", "Avaritia");
            this.addBlock((Supplier)AvaritiaModContent.NEUTRONIUM_STORAGE_BLOCK, "Neutronium Block");
            this.addBlock((Supplier)AvaritiaModContent.INFINITY_STORAGE_BLOCK, "Infinity Block");
            this.addBlock((Supplier)AvaritiaModContent.CRYSTAL_MATRIX_STORAGE_BLOCK, "Crystal Matrix Block");
            this.addBlock((Supplier)AvaritiaModContent.COMPRESSED_CRAFTING_TABLE_BLOCK, "Compressed Crafting Table");
            this.addBlock((Supplier)AvaritiaModContent.DOUBLE_COMPRESSED_CRAFTING_TABLE_BLOCK, "Double Compressed Crafting Table");
            this.addBlock((Supplier)AvaritiaModContent.EXTREME_CRAFTING_TABLE_BLOCK, "Extreme Crafting Table");
            this.addBlock((Supplier)AvaritiaModContent.COMPRESSOR_BLOCK, "Neutronium Compressor");
            this.addBlock((Supplier)AvaritiaModContent.NEUTRON_COLLECTOR_BLOCK, "Neutron Collector");
            this.addItem((Supplier)AvaritiaModContent.DIAMOND_LATTICE, "Diamond Lattice");
            this.addItem((Supplier)AvaritiaModContent.CRYSTAL_MATRIX_INGOT, "Crystal Matrix Ingot");
            this.addItem((Supplier)AvaritiaModContent.NEUTRON_PILE, "Pile of Neutrons");
            this.addItem((Supplier)AvaritiaModContent.NEUTRON_NUGGET, "Neutronium Nugget");
            this.addItem((Supplier)AvaritiaModContent.NEUTRONIUM_INGOT, "Neutronium Ingot");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_CATALYST, "Infinity Catalyst");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_INGOT, "Infinity Ingot");
            this.addItem((Supplier)AvaritiaModContent.RECORD_FRAGMENT, "Record Fragment");
            this.addItem((Supplier)AvaritiaModContent.IRON_SINGULARITY, "Iron Singularity");
            this.addItem((Supplier)AvaritiaModContent.GOLD_SINGULARITY, "Gold Singularity");
            this.addItem((Supplier)AvaritiaModContent.LAPIS_SINGULARITY, "Lapis Singularity");
            this.addItem((Supplier)AvaritiaModContent.REDSTONE_SINGULARITY, "Redstone Singularity");
            this.addItem((Supplier)AvaritiaModContent.QUARTZ_SINGULARITY, "Quartz Singularity");
            this.addItem((Supplier)AvaritiaModContent.COPPER_SINGULARITY, "Copper Singularity");
            this.addItem((Supplier)AvaritiaModContent.TIN_SINGULARITY, "Tin Singularity");
            this.addItem((Supplier)AvaritiaModContent.LEAD_SINGULARITY, "Lead Singularity");
            this.addItem((Supplier)AvaritiaModContent.SILVER_SINGULARITY, "Silver Singularity");
            this.addItem((Supplier)AvaritiaModContent.NICKEL_SINGULARITY, "Nickel Singularity");
            this.addItem((Supplier)AvaritiaModContent.DIAMOND_SINGULARITY, "Diamond Singularity");
            this.addItem((Supplier)AvaritiaModContent.EMERALD_SINGULARITY, "Emerald Singularity");
            this.addItem((Supplier)AvaritiaModContent.FLUXED_SINGULARITY, "Fluxed Singularity");
            this.addItem((Supplier)AvaritiaModContent.PLATINUM_SINGULARITY, "Platinum Singularity");
            this.addItem((Supplier)AvaritiaModContent.IRIDIUM_SINGULARITY, "Iridium Singularity");
            this.addItem((Supplier)AvaritiaModContent.NETHERITE_SINGULARITY, "Netherite Singularity");
            this.addItem((Supplier)AvaritiaModContent.AMETHYST_SINGULARITY, "Amethyst Singularity");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_AXE, "Nature's Ruin");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_BOW, "Longbow of the Heavens");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_HOE, "Hoe of the Green Earth");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_PICKAXE, "World Breaker");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_SHOVEL, "Planet Eater");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_SWORD, "Sword of the Cosmos");
            this.addItem((Supplier)AvaritiaModContent.SKULLFIRE_SWORD, "Skullfire Sword");
            this.add("desc.avaritia.skullfire_sword", "Beheads skeletons and scorches them black.");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_HELMET, "Infinity Helmet");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_CHESTPLATE, "Infinity Breastplate");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_LEGS, "Infinity Leggings");
            this.addItem((Supplier)AvaritiaModContent.INFINITY_BOOTS, "Infinity Boots");
            this.add(NeutroniumCompressorScreen.TITLE.m_131328_(), "Neutronium Compressor");
            this.add(NeutronCollectorScreen.TITLE.m_131328_(), "Neutron Collector");
            this.add("avaritia:container.extreme_crafting.title", "Extreme Crafting");
            this.addItem((Supplier)AvaritiaModContent.MATTER_CLUSTER, "Matter Cluster");
            this.add("avaritia:matter_cluster.counter", "%s / %s items");
            this.add("avaritia:matter_cluster.desc", "Use to deconstruct");
            this.add("avaritia:matter_cluster.desc2", "Hold SHIFT for contents");
            this.addItem((Supplier)AvaritiaModContent.ULTIMATE_STEW, "Ultimate Stew");
            this.addItem((Supplier)AvaritiaModContent.COSMIC_MEATBALLS, "Cosmic Meatballs");
            this.addItem((Supplier)AvaritiaModContent.ENDEST_PEARL_ITEM, "Endest Pearl");
        }
    }
}

